s=poly(0,'s');
clf();

//****** 降圧チョッパ回路のパラメタ設定 ******

Vi = 12;                       // 降圧チョッパ入力電圧
R = 5;                         // 負荷抵抗値
L = 30*10^-6;                  // インダクタンス
C = 100*10^-6;                 // 出力容量
D = 5/12;                      // バイアス点におけるデューティ比（出力電圧÷入力電圧）
fs = 100*10^3                  // スイッチング周波数
Vm = 2;                        // PWMの変調波振幅
Hv = 0.4;                      // 出力電圧検出器のゲイン
Hc = 0.5;                        // インダクタ電流検出器のゲイン

Ts = 1/fs;                     // スイッチング周期
Vo = D*Vi;                     // 降圧チョッパ出力電圧
Q = R*(C/L)^0.5;               // Q値
wo =(L*C)^-0.5;                // 固有角周波数
fo = wo/2/%pi                  // 固有周波数

//****** PCMCの制御パラメタ ******

Ma = 4/(30*10^-6);            // PCMC スロープ補償 鋸歯状波の傾き
Fg = D^2*Ts*(2*L)^-1;          // PCMC 入力電圧からデューティ比へのゲイン
Fv = Ts*(1-2*D)*(2*L)^-1;      // PCMC 出力電圧からデューティ比へのゲイン
Fm = (Ma*Ts)^-1;               // PCMC 共通因子

//****** 降圧チョッパ伝達関数 ******

den = 1+L*s/R+L*C*s^2                               // 伝達関数の共通分母

Gvivo = syslin('c',D/den)                           // 入力電圧から出力電圧への伝達関数
Gdvo = syslin('c',Vi/den)                           // デューティ比から出力電圧への伝達関数
Gdi = syslin('c',Vi/R*(1+R*C*s)/den)                // デューティ比からインダクタ電流への伝達関数
Givo = syslin('c',R*(1+R*C*s)^-1)                   // インダクタ電流から出力電圧への伝達関数
Gac = syslin('c',1/Vm*Gdi/(1+1/Vm*Gdi*Hc))          // ACMC（平均電流モード制御）のインナーループ伝達関数
Gipvo = syslin('c',R/Hc/(1+R*C*s))                    // PCMCのピーク電流から出力電圧への伝達関数(近似モデル)
Gipvo2 = syslin('c',Fm*Gdvo*(1+Fm*(Gdi+Fv*Gdvo))^-1)  // PCMCのピーク電流から出力電圧への伝達関数(厳密なモデル)

//****** PI制御器の伝達関数 ******

Tpi = 0.000025;                          // PI制御器の時定数
Kpi = 13.3;                            // PI制御器のゲイン
Gpi = syslin('c',Kpi*(1+1/(Tpi*s)))    // PI制御器の伝達関数

//****** Type III 制御器の伝達関数 ******

K3 = 1;                             // Type III 制御器のゲイン
fz1 =10*10^3;                       // Type III 制御器の 1st ゼロ点周波数
fz2 =10*10^3;                       // Type III 制御器の 2nd ゼロ点周波数
fp1 =50*10^3;                       // Type III 制御器の 1st 極周波数
fp2 =50*10^3;                       // Type III 制御器の 2nd 極周波数
Gc3 = syslin('c',2*%pi*fz1*K3*(1+s/(2*%pi*fz1))*(1+s/(2*%pi*fz2))*(1+s/(2*%pi*fp1))^-1*(1+s/(2*%pi*fp2))^-1*s^-1)// Type III 制御器の伝達関数

/////////////////////////////////////////





//****** コードを入力してください ******

bode(0.2*Gdvo,10,100*10^3)





















